// ContentsEscP.cpp : CContentsEscP Class source code
//

#include "stdafx.h"
#include "defsfile.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

IMPLEMENT_SERIAL(CContentsEscP, CObject, 1)



// Serialize draw data
void CContentsEscP::Serialize(CArchive& ar)
{
    CObject::Serialize(ar);

    if (ar.IsStoring ())
        ar.Write(&m_Data,sizeof(m_Data)) ;
    else
        ar.Read(&m_Data,sizeof(m_Data)) ;
}

// Draw to Window
void CContentsEscP::Draw(CDC* pDC)
{
	CGpWinPen Pen( m_Data.cLimitColor,0) ;
	CGpWinBrush Brush( m_Data.cTile) ;

	CPen* pOldPen         = pDC->SelectObject((CPen* )&Pen);
	int OldBkMode         = pDC->SetBkMode( OPAQUE );
	COLORREF OldBkColor   = pDC->SetBkColor(GpToWinColor(m_Data.cBackColor));
	CBrush* pOldBrush     = pDC->SelectObject((CBrush* )&Brush);
	COLORREF OldTextColor = pDC->SetTextColor(GpToWinColor(m_Data.cDisplayColor));
	
	pDC->RoundRect(m_Data.iX1-8,m_Data.iY1-8,m_Data.iX1+8,m_Data.iY1+8,4,4);

	pDC->SetBkMode(OldBkMode );
	pDC->SetBkColor( OldBkColor );
	pDC->SelectObject(pOldPen);
	pDC->SelectObject(pOldBrush);
	pDC->SetTextColor(OldTextColor);
}

// Transmit the data to GP
int CContentsEscP::Transition( CMemSock* pCMemSock)
{
	return( pCMemSock->MtoMESC_P(m_Data.cDisplayColor,m_Data.cBackColor,m_Data.cTile,m_Data.cLimitColor,m_Data.iX1,m_Data.iY1)) ;
}
